#ifndef __BOOT_H
#define __BOOT_H

/* 

	USB Data Logger BootLoader, by Mauro Grassi, Dec. 2010.

*/ 

#include "ff.h"
#include "usb_device.h"
#include "usb_function_generic.h"
 
#define BOOTLOADER_VERSION						(101)
#define BOOTLOADER_ADDRESS						(0x1DC00)
#define SERIAL_BOOTLOADER_ADDRESS				(0x1D400)

#define USE_BOOT_UART							0
#define USE_BOOT_WRITE_WORD_FLASH				0

#define COUNTER_PERIOD_OFF						100000
#define COUNTER_PERIOD_OFF_SHORT				15000	
#define COUNTER_PERIOD_ON						2500
#define COUNTER_PERIOD_SHORT					1000

#define BOOT_HOST_TIMEOUT						100000
#define BOOT_RESET_TIMEOUT						100000

#define CODE_NONE								0
#define CODE_ONE								1
#define CODE_TWO								2

#define SIZE_USB_PACKET							64
#define USB_FDIR_NAME_SIZE						(SIZE_USB_PACKET-12)

#define KEY_TRIS								(TRISAbits.TRISA5)	
#define KEY_PORT								(PORTAbits.RA5)

#define CMD_GET_PROGRAM_MEMORY_AT				0xA0
#define CMD_PUT_PROGRAM_MEMORY_AT				0xA1
#define CMD_ERASE_PROGRAM_MEMORY_AT				0xA2
#define CMD_BOOT_RESET							0xA3
#define CMD_GET_BOOTLOADER_STATUS				0xA4
#define CMD_SET_FLASH_ADDRESS					0xA5
#define CMD_WRITE_WORD_FLASH					0xA6

#define BOOT_PAYLOAD_SIZE						56

typedef struct
{
	FRESULT 		fresult;
	WORD 			lfsize;
	DWORD			fsize;
	WORD  			fdate;
	WORD			ftime;
	unsigned char	fattrib;
	unsigned char   fname[USB_FDIR_NAME_SIZE];
} DIR_ENTRY;
	
typedef union
{
	unsigned char data[SIZE_USB_PACKET];
	DIR_ENTRY	  fdir;	
} USB_PACKET;

extern USB_PACKET				OUTPacket;			// User application buffer for receiving and holding OUT packets sent from the host
extern USB_PACKET				INPacket;			// User application buffer for sending IN packets to the host
extern USB_HANDLE				USBGenericOutHandle;
extern USB_HANDLE				USBGenericInHandle;
extern unsigned char			bootFunction;

void main(void);
/* prototype for the startup function */
void _entry (void);
void _startup (void);
unsigned char ProcessBootTask(unsigned long*);

#endif
